// pool.js
(function () {
  const ballsList = [
    "/images/ball1.png",
    "/images/ball2.png",
    "/images/ball3.png",
    "/images/ball4.png",
    "/images/ball5.png",
    "/images/ball6.png",
    "/images/ball7.png",
    "/images/ball8.png",
    "/images/ball9.png",
    "/images/ball10.png",
    "/images/ball11.png",
    "/images/ball12.png",
    "/images/ball13.png",
    "/images/ball14.png",
    "/images/ball15.png",
  ];

  let ws;
  const serverIp = window.location.hostname;
  const serverPort = 8085;
  const roomId = localStorage.getItem("ROOM_ID");
  const clientId = localStorage.getItem("CLIENT_ID");

  if (!roomId) {
    alert(" Không tìm thấy Room ID. Vui lòng quay lại kết nối!");
    window.location.href = "/index.html";
    return;
  }

  // Biến heartbeat hoàn chỉnh
  let isActionLocked = false;
  const lockDuration = 500;
  let heartbeatInterval = null;
  let pingTimeout = null;
  let isAlive = false;
  let lastItemBalls = 0;
  let matchType = 0;
  let totalBalls = 0;
  let configRequestTimePool = 0;
  let img;
  let balls = [];
  let newBalls = [];
  let players = [];
  let currentIndex = players.findIndex((p) => p.isActive) || 0;
  // let isRunning = JSON.parse(localStorage.getItem("IS_PAUSED")) || false;
  let isRunning = false;
  let timeOut = 0;
  let gameStart = false;
  let gameRunning = false;
  let timeMode = 0;

  function getInitialBalls(total) {
    return Array.from({ length: total }, (_, i) => i + 1);
  }

  const titleEl = document.querySelector("#titleEl");
  const btnDisconnect = document.querySelector(".btn-disconect");
  const btnTakeTurn = document.querySelector(".btn-turn");
  const btnAskForTime = document.querySelector(".btn-time");
  const btnIncrease = document.querySelector(".btn-add");
  const btnPause = document.querySelector(".btn-pause");
  const btnDisIncrease = document.querySelector(".btn-subtract");
  const extraTime = document.querySelector(".extra-time");
  const btnNewRound = document.querySelector(".btn-new");
  const btnFoul = document.querySelector(".btn-foul");
  const foulText = document.querySelector(".text-foul");
  const btnChangeBall = document.querySelector(".btn-change-ball");

  function stopHeartbeat() {
    if (heartbeatInterval) {
      clearInterval(heartbeatInterval);
      heartbeatInterval = null;
    }
    if (pingTimeout) {
      clearTimeout(pingTimeout);
      pingTimeout = null;
    }
    isAlive = false;
  }

  function executeAction(callback) {
    if (isActionLocked) return;
    isActionLocked = true;

    callback();

    setTimeout(() => {
      isActionLocked = false;
    }, lockDuration);
  }

  function updateChangeBallButtonVisibility() {
    const btnChangeBall = document.getElementById("change-ball-btn");
    if (!btnChangeBall) return;

    if (matchType === 6) {
      btnChangeBall.classList.remove("btn-hidden");
    } else {
      btnChangeBall.classList.add("btn-hidden");
    }
  }

  function updatePauseButtonVisibility() {
    const btnPause = document.getElementById("pause-btn");
    const btnTime = document.getElementById("time-btn");

    if (!btnPause || !btnTime) return;

    if (timeMode === 1) {
      btnPause.classList.remove("btn-hidden");
      btnTime.classList.remove("btn-hidden");

      // Cập nhật trạng thái nút Tạm dừng
      btnPause.textContent = !isRunning ? "TIẾP TỤC" : "TẠM DỪNG";
      btnPause.style.backgroundColor = !isRunning ? "orange" : "red";
      btnPause.style.color = "white";
    } else {
      btnPause.classList.add("btn-hidden");
      btnTime.classList.add("btn-hidden");
    }

    localStorage.setItem("IS_PAUSED", JSON.stringify(isRunning));
  }

  function startHeartbeat() {
    stopHeartbeat();

    isAlive = true;

    heartbeatInterval = setInterval(() => {
      if (ws && ws.readyState === WebSocket.OPEN) {
        // Nếu chưa nhận được pong từ lần ping trước
        if (!isAlive) {
          console.warn("No pong received, closing connection");
          ws.close();
          return;
        }

        isAlive = false; // Đánh dấu chưa nhận pong

        ws.send(
          JSON.stringify({
            type: "ping",
            timestamp: Date.now(),
          }),
        );

        // Set timeout để kiểm tra pong (10 giây)
        pingTimeout = setTimeout(() => {
          if (!isAlive) {
            console.warn("Ping timeout, closing connection");
            ws.close();
          }
        }, 10000); // 10 giây timeout
      }
    }, 30000); // 30 giây
  }

  function renderPlayer() {
    if (players.length > 0) {
      const currentPlayer = players.find((p) => p.isActive);

      if (titleEl) {
        titleEl.value = currentPlayer?.name || "Chưa có người chơi";
      }
      if (timeMode === 1) {
        if (extraTime) {
          if (currentPlayer) {
            if (currentPlayer.extraTime === -1) {
              extraTime.innerHTML =
                '<i class="fas fa-infinity timeout-icon" style="color: #4CAF50;"></i> Tổng lượt xin: không giới hạn';
            } else if (currentPlayer.extraTime === 0) {
              // Hiển thị tất cả icon màu xám khi hết lượt
              const timeoutIcons = Array.from({ length: timeOut })
                .map(() => {
                  return '<i class="fas fa-stopwatch timeout-icon" style="color: #B0BEC5; margin: 0 2px;"></i>';
                })
                .join("");
              extraTime.innerHTML = `Tổng lượt xin: ${timeoutIcons}`;
            } else {
              // Hiển thị kết hợp icon xanh (còn lại) và xám (đã dùng)
              const remainingIcons = Array.from({
                length: currentPlayer.extraTime,
              })
                .map(() => {
                  return '<i class="fas fa-stopwatch timeout-icon" style="color: #4CAF50; margin: 0 2px;"></i>';
                })
                .join("");

              const usedIcons = Array.from({
                length: timeOut - currentPlayer.extraTime,
              })
                .map(() => {
                  return '<i class="fas fa-stopwatch timeout-icon" style="color: #B0BEC5; margin: 0 2px;"></i>';
                })
                .join("");

              extraTime.innerHTML = `Tổng lượt xin: ${remainingIcons}${usedIcons}`;
            }
          } else {
            extraTime.textContent = "";
          }
        }
      }

      if (foulText) {
        if (currentPlayer) {
          foulText.textContent = "Lỗi: " + currentPlayer.foul || 0;
        } else {
          extraTime.textContent = "";
        }
      }

      // Nếu matchType == 6 thì render UI đặc biệt
      if (matchType === 6) {
        const wrapperBall = document.querySelector(".wrapper-ball");
        if (wrapperBall) {
          wrapperBall.remove();
        }

        let container = document.querySelector(".match-type-6");
        if (!container) {
          container = document.createElement("div");
          container.className = "match-type-6";
          document.body.appendChild(container);
        }

        container.innerHTML = "";
        // Lấy điểm từ players
        const leftPlayer = players[0];
        const rightPlayer = players[1];

        const leftScore = leftPlayer?.pointHistory?.length || 0;
        const rightScore = rightPlayer?.pointHistory?.length || 0;

        const leftBallImage =
          leftPlayer?.isFirstBallHitter === 1
            ? "/images/ball1.png"
            : "/images/ball9.png";

        const rightBallImage =
          leftPlayer?.isFirstBallHitter === 1
            ? "/images/ball9.png"
            : "/images/ball1.png";

        container.innerHTML = `
    <div class="side left">
      <img src="${leftBallImage}" class="ball" />
      <div class="arrows">
        <span class="arrow up" data-side="left">↑</span>
        <span class="arrow down" data-side="left">↓</span>
      </div>
      <span class="score" data-side="left">${leftScore}</span>
    </div>
    <div class="center">
      <img src="/images/ball8.png" class="ball" />
    </div>
    <div class="side right">
      <img src="${rightBallImage}" class="ball" />
      <span class="score" data-side="right">${rightScore}</span>
      <div class="arrows">
        <span class="arrow up" data-side="right">↑</span>
        <span class="arrow down" data-side="right">↓</span>
      </div>
    </div>
  `;

        // Xác định index của currentPlayer
        let currentIndex = players.findIndex((p) => p.isActive);
        if (currentIndex === -1) currentIndex = 0; // fallback

        // Map index -> side
        const indexToSideNewRound = {
          0: "left",
          1: "right",
        };

        // Gắn sự kiện cho tất cả mũi tên
        container.querySelectorAll(".arrow").forEach((btn) => {
          btn.addEventListener("click", () => {
            if (players.length === 0 || (!isRunning && timeMode === 1)) return;
            if (!gameStart || !gameRunning) return;
            const hasPlayerReached8Points = players.some(
              (player) =>
                player.pointHistory && player.pointHistory.length === 8,
            );
            if (hasPlayerReached8Points) return;
            const side = btn.getAttribute("data-side"); // left | right
            if (!side) return;

            // chỉ cho bấm nếu side == currentIndex
            if (side !== indexToSideNewRound[currentIndex]) return;

            const scoreEl = container.querySelector(
              `.score[data-side="${side}"]`,
            );
            let currentScore = parseInt(scoreEl.textContent, 10) || 0;

            if (btn.classList.contains("up")) {
              if (currentScore < 8) {
                currentScore++;
                players[currentIndex].pointHistory.push(1);
                sendData(currentIndex, "update_score_pool", +1);
                if (players[currentIndex].pointHistory.length === 8) {
                  players[currentIndex].score += 1;
                }
              }
            } else if (btn.classList.contains("down")) {
              if (players[currentIndex].pointHistory.length > 0) {
                players[currentIndex].pointHistory.pop(); // bớt điểm
                currentScore--;
                sendData(currentIndex, "update_score_pool", -1);
              }
            }

            scoreEl.textContent = currentScore;
            // cập nhật player
            // players[currentIndex].totalScore = currentScore;
            renderPlayer();
          });
        });

        return; // không chạy render balls mặc định
      }

      if (balls) {
        const setBalls = new Set(balls.map((n) => `/images/ball${n}.png`));
        newBalls = ballsList.filter((x) => setBalls.has(x));

        // Tìm container đã có hoặc tạo mới nếu chưa có
        let container = document.querySelector(".balls-container");
        if (!container) {
          container = document.createElement("div");
          container.className = "balls-container";
          document.body.appendChild(container);
        }

        // player ăn bi
        const wrapperBall = document.querySelector(".wrapper-ball");
        wrapperBall.innerHTML = ""; // xóa cũ

        currentPlayer.ball.forEach((ballNumber) => {
          const gotImg = document.createElement("img");
          gotImg.src = `/images/ball${ballNumber}.png`;
          gotImg.className = "got-ball";
          gotImg.addEventListener("click", () => {
            // Xóa khỏi currentPlayer.ball
            wrapperBall.style.pointerEvents = "none";
            wrapperBall.style.opacity = "0.5";
            if (!gameStart) return;
            if (!isRunning && timeMode === 1) return;
            currentPlayer.ball = currentPlayer.ball.filter(
              (n) => n !== ballNumber,
            );

            // Thêm lại vào balls
            balls.push(ballNumber);

            if (ws && ws.readyState === WebSocket.OPEN) {
              const payload = {
                type: "command",
                action: "return_ball",
                data: {
                  ball: ballNumber,
                  playerId: currentPlayer.id,
                },
              };
              ws.send(JSON.stringify(payload));
            }
            if (ballNumber === lastItemBalls) {
              container.style.pointerEvents = "auto";
              container.style.opacity = "1";
            }
            // Render lại
            renderPlayer();
            setTimeout(() => {
              wrapperBall.style.pointerEvents = "auto";
              wrapperBall.style.opacity = "1";
            }, 500);
          });

          wrapperBall.appendChild(gotImg);
        });

        // Xóa hết nội dung cũ để tránh lặp
        container.innerHTML = "";
        // Render lại bóng
        newBalls.forEach((src) => {
          img = document.createElement("img");
          img.src = src;
          img.className = "ball-img";

          img.addEventListener("click", () => {
            if (!gameStart) return;
            if (!isRunning && timeMode === 1) return;
            const ballNumber = parseInt(src.match(/ball(\d+)\.png$/)[1], 10);
            container.style.pointerEvents = "none";
            container.style.opacity = "0.5";
            if (ws && ws.readyState === WebSocket.OPEN) {
              const payload = {
                type: "command",
                action: "remove_ball",
                data: {
                  ball: ballNumber,
                  playerId: currentPlayer.id,
                },
              };
              currentPlayer.foul = 0;
              ws.send(JSON.stringify(payload));
              if (
                ballNumber === lastItemBalls &&
                players[currentIndex].id === currentPlayer.id
              ) {
                players[currentIndex].score += 1;
              }
            }

            balls = balls.filter((n) => n !== ballNumber);
            currentPlayer.ball.push(ballNumber);
            if (ballNumber === lastItemBalls) {
              container.style.pointerEvents = "none";
              container.style.opacity = "0.5";
            } else {
              setTimeout(() => {
                container.style.pointerEvents = "auto";
                container.style.opacity = "1";
              }, 500);
            }
            renderPlayer();
          });

          container.appendChild(img);
        });
      }

      // if (countdownInterval) clearInterval(countdownInterval);
      // btnAskForTime.textContent = "XIN THỜI GIAN";
      // canAskForTime = true;
    }
    updatePauseButton();
  }

  if (titleEl) {
    titleEl.addEventListener("input", () => {
      const newName = titleEl.value;
      const currentPlayer = players[currentIndex];

      if (currentPlayer && newName) {
        currentPlayer.name = newName; // cập nhật local
        renderPlayer(); // render lại giao diện
        // gửi socket
        sendData(currentIndex, "change_name");
      }
    });
  }
  function updatePauseButton() {
    const btnPause = document.getElementById("pause-btn");
    if (!btnPause) return;

    if (timeMode === 1) {
      btnPause.classList.remove("btn-hidden");

      btnPause.textContent = !isRunning ? "TIẾP TỤC" : "TẠM DỪNG";
      btnPause.style.backgroundColor = !isRunning ? "orange" : "red";
      btnPause.style.color = "white";
    } else {
      btnPause.classList.add("btn-hidden");
    }

    localStorage.setItem("IS_PAUSED", JSON.stringify(isRunning));
  }

  function sendData(activeIndex, action, value) {
    if (ws && ws.readyState === WebSocket.OPEN) {
      let payload = null;

      if (action === "switch_turn") {
        payload = {
          type: "command",
          action: "switch_turn",
          data: {
            playerId: players[activeIndex].id,
            isActive: players[activeIndex].isActive,
          },
        };
      }
      if (action === "change_ball_pool") {
        payload = {
          type: "command",
          action: "change_ball_pool",
          data: {
            playerId: players[activeIndex].id,
            isFirstBallHitter: players[activeIndex].isFirstBallHitter,
          },
        };
      }
      if (action === "update_score") {
        payload = {
          type: "command",
          action: "update_score",
          data: {
            playerId: players[activeIndex].id,
            name: players[activeIndex].name,
            score: players[activeIndex].score,
            isActive: players[activeIndex].isActive,
          },
        };
      }
      if (action === "request_extra_time") {
        payload = {
          type: "command",
          action: "request_extra_time",
          data: {
            playerId: players[activeIndex].id,
            extraTime: players[activeIndex].extraTime,
            isActive: players[activeIndex].isActive,
          },
        };
      }
      if (action === "toggle_pause") {
        payload = {
          type: "command",
          action: "toggle_pause",
          data: {
            isRunning: isRunning,
          },
        };
      }
      if (action === "change_name") {
        payload = {
          type: "command",
          action: "change_name",
          data: {
            playerId: players[activeIndex].id,
            name: players[activeIndex].name,
          },
        };
      }
      if (action === "update_score_pool") {
        payload = {
          type: "command",
          action: "update_score_pool",
          data: {
            playerId: players[activeIndex].id,
            value: value,
            isActive: players[activeIndex].isActive,
          },
        };
      }
      if (action === "update_foul") {
        payload = {
          type: "command",
          action: "update_foul",
          data: {
            playerId: players[activeIndex].id,
          },
        };
      }

      if (payload) {
        ws.send(JSON.stringify(payload));
      } else {
        console.warn("WebSocket is not open, cannot send data");
      }
    }
  }

  function connectWebSocket() {
    try {
      ws = new WebSocket(SOCKET_URL);
      setupWebSocketEvents();
    } catch (error) {
      console.error("WebSocket connection error:", error);
    }
  }

  function setupWebSocketEvents() {
    if (!ws) return;

    ws.onopen = () => {
      // Join room lại
      ws.send(
        JSON.stringify({
          type: "join-room",
          room: roomId,
          clientId: clientId,
          device: "web",
        }),
      );

      ws.send(
        JSON.stringify({
          type: "get-initial-data",
          from: clientId, // để biết gửi lại cho ai
          room: roomId,
        }),
      );
      startHeartbeat();
    };

    ws.onmessage = (event) => {
      try {
        const message = JSON.parse(event.data);
        // Xử lý ping/pong từ server hoặc từ app clients
        if (message.type === "pong") {
          isAlive = true;
          if (pingTimeout) {
            clearTimeout(pingTimeout);
            pingTimeout = null;
          }
          return;
        }

        if (message.type === "ping") {
          // Trả lời ping từ server hoặc từ app clients
          ws.send(
            JSON.stringify({
              type: "pong",
              timestamp: message.timestamp,
            }),
          );
          return;
        }

        switch (message.type) {
          case "initial-data":
            matchType = message.data.matchType;
            balls = message.data.ballsList;
            totalBalls = message.data.ballsList.length;
            players = message.data.players || [];
            isRunning = message.data.isRunning;
            configRequestTimePool = message.data.configRequestTimePool;
            timeOut = message.data.timeOut;
            gameStart = message.data.gameStart;
            gameRunning = message.data.gameRunning;
            timeMode = message.data.timeMode;

            const activeIdx = players.findIndex((p) => p.isActive);
            currentIndex = activeIdx !== -1 ? activeIdx : 0;
            localStorage.setItem("IS_PAUSED", JSON.stringify(isRunning));
            console.log("message.data", message.data);

            updateChangeBallButtonVisibility();
            updatePauseButtonVisibility();
            updatePauseButton();

            if (message.data.matchType === 4) {
              lastItemBalls = 9;
            } else if (message.data.matchType === 5) {
              lastItemBalls = 10;
            }
            renderPlayer();
            updatePauseButton();
            break;

          case "control":
            switch (message.action) {
              case "toggle_pause":
                isRunning = message.data.isRunning;
                localStorage.setItem("IS_PAUSED", JSON.stringify(isRunning));
                renderPlayer();
                updatePauseButton();
                break;
              case "app_update_game_start":
                gameStart = message.data.gameStart;
                gameRunning = true;
                renderPlayer();
                break;
              case "app_update_game_running":
                gameRunning = message.data.gameRunning;
                renderPlayer();
                break;
              case "new_round_pool":
                players.forEach((p) => {
                  p.pointHistory = [];
                  if (configRequestTimePool !== 0) {
                    p.extraTime = timeOut;
                  }
                });
                renderPlayer();
                break;
              case "app_change_ball_pool":
                // Lấy 2 người chơi đầu tiên
                if (players.length !== 2) return;

                const newIsFirstBallHitter = message.data.isFirstBallHitter;
                const updatedPlayerId = message.data.playerId;
                console.log("updatedPlayerId", updatedPlayerId);
                console.log("newIsFirstBallHitter", newIsFirstBallHitter);

                players = players.map((player) => {
                  if (player.id === updatedPlayerId) {
                    return {
                      ...player,
                      isFirstBallHitter: newIsFirstBallHitter,
                    };
                  } else {
                    return {
                      ...player,
                      isFirstBallHitter: newIsFirstBallHitter === 1 ? 0 : 1,
                    };
                  }
                });

                renderPlayer();
                break;
              case "update_score_pool":
                players = players.map((p) =>
                  p.id === message.data.playerId
                    ? {
                        ...p,
                        pointHistory: [...message.data.pointHistory],
                        score:
                          message.data.pointHistory.length === 8
                            ? p.score + 1
                            : p.score,
                      }
                    : p,
                );

                let container = document.querySelector(".match-type-6");
                if (!container) {
                  container = document.createElement("div");
                  container.className = "match-type-6";
                  document.body.appendChild(container);
                }

                container.innerHTML = "";
                const leftPlayer = players[0];
                const rightPlayer = players[1];

                const leftScore = leftPlayer?.pointHistory?.length || 0;
                const rightScore = rightPlayer?.pointHistory?.length || 0;

                const leftBallImage =
                  leftPlayer?.isFirstBallHitter === 1
                    ? "/images/ball1.png"
                    : "/images/ball9.png";

                const rightBallImage =
                  leftPlayer?.isFirstBallHitter === 1
                    ? "/images/ball9.png"
                    : "/images/ball1.png";

                container.innerHTML = `
    <div class="side left">
      <img src="${leftBallImage}" class="ball" />
      <div class="arrows">
        <span class="arrow up" data-side="left">↑</span>
        <span class="arrow down" data-side="left">↓</span>
      </div>
      <span class="score" data-side="left">${leftScore}</span>
    </div>
    <div class="center">
      <img src="/images/ball8.png" class="ball" />
    </div>
    <div class="side right">
      <img src="${rightBallImage}" class="ball" />
      <span class="score" data-side="right">${rightScore}</span>
      <div class="arrows">
        <span class="arrow up" data-side="right">↑</span>
        <span class="arrow down" data-side="right">↓</span>
      </div>
    </div>
  `;

                // Xác định index của currentPlayer
                if (currentIndex === -1) currentIndex = 0; // fallback

                // Map index -> side
                const indexToSide = {
                  0: "left",
                  1: "right",
                };

                // Gắn sự kiện cho tất cả mũi tên
                container.querySelectorAll(".arrow").forEach((btn) => {
                  btn.addEventListener("click", () => {
                    if (players.length === 0 || (!isRunning && timeMode === 1))
                      return;
                    if (!gameStart || !gameRunning) return;
                    const hasPlayerReached8Points = players.some(
                      (player) =>
                        player.pointHistory && player.pointHistory.length === 8,
                    );
                    if (hasPlayerReached8Points) return;
                    const side = btn.getAttribute("data-side"); // left | right
                    if (!side) return;

                    // chỉ cho bấm nếu side == currentIndex
                    if (side !== indexToSide[currentIndex]) return;

                    const scoreEl = container.querySelector(
                      `.score[data-side="${side}"]`,
                    );
                    let currentScore = parseInt(scoreEl.textContent, 10) || 0;

                    if (btn.classList.contains("up")) {
                      if (currentScore < 8) {
                        currentScore++;
                        players[currentIndex].pointHistory.push(1);
                        sendData(currentIndex, "update_score_pool", +1);
                      }
                    } else if (btn.classList.contains("down")) {
                      if (players[currentIndex].pointHistory.length > 0) {
                        players[currentIndex].pointHistory.pop(); // bớt điểm
                        currentScore--;
                        sendData(currentIndex, "update_score_pool", -1);
                      }
                    }

                    scoreEl.textContent = currentScore;
                  });
                });
                break;
              case "new_round":
                if (message.data.matchType === 6) {
                  players.forEach((p) => (p.pointHistory = []));
                  let containerNewRoundPool =
                    document.querySelector(".match-type-6");
                  if (!containerNewRoundPool) {
                    containerNewRoundPool = document.createElement("div");
                    containerNewRoundPool.className = "match-type-6";
                    document.body.appendChild(containerNewRoundPool);
                  }

                  containerNewRoundPool.innerHTML = "";
                  // Lấy điểm từ players
                  // const leftPlayerNewRoundPool = players[0];
                  // const rightPlayerNewRoundPool = players[1];

                  // const leftScoreNewRoundPool =
                  //   leftPlayerNewRoundPool?.pointHistory?.length || 0;
                  // const rightScoreNewRoundPool =
                  //   rightPlayerNewRoundPool?.pointHistory?.length || 0;

                  containerNewRoundPool.innerHTML = `
    <div class="side left">
    <img src="/images/ball9.png" class="ball" />
      <div class="arrows">
        <span class="arrow up" data-side="left">↑</span>
        <span class="arrow down" data-side="left">↓</span>
      </div>
       <span class="score" data-side="left">${leftScore}</span>
    </div>
    <div class="center">
      <img src="/images/ball8.png" class="ball" />
    </div>
    <div class="side right">
      <img src="/images/ball1.png" class="ball" />
      <span class="score" data-side="right">${rightScore}</span>
      <div class="arrows">
        <span class="arrow up" data-side="right">↑</span>
        <span class="arrow down" data-side="right">↓</span>
      </div>
    </div>
  `;

                  if (currentIndex === -1) currentIndex = 0; // fallback

                  // Map index -> side
                  const indexToSideNewRoundPool = {
                    0: "left",
                    1: "right",
                  };

                  // Gắn sự kiện cho tất cả mũi tên
                  containerNewRoundPool
                    .querySelectorAll(".arrow")
                    .forEach((btn) => {
                      btn.addEventListener("click", () => {
                        if (
                          players.length === 0 ||
                          (!isRunning && timeMode === 1)
                        )
                          return;
                        if (!gameStart || !gameRunning) return;
                        const hasPlayerReached8Points = players.some(
                          (player) =>
                            player.pointHistory &&
                            player.pointHistory.length === 8,
                        );
                        if (hasPlayerReached8Points) return;
                        const side = btn.getAttribute("data-side"); // left | right
                        if (!side) return;

                        // chỉ cho bấm nếu side == currentIndex
                        if (side !== indexToSideNewRoundPool[currentIndex])
                          return;

                        const scoreEl = containerNewRoundPool.querySelector(
                          `.score[data-side="${side}"]`,
                        );
                        let currentScore =
                          parseInt(scoreEl.textContent, 10) || 0;

                        if (btn.classList.contains("up")) {
                          if (currentScore < 8) {
                            currentScore++;
                            players[currentIndex].pointHistory.push(1);
                            sendData(currentIndex, "update_score_pool", +1);
                          }
                        } else if (btn.classList.contains("down")) {
                          if (players[currentIndex].pointHistory.length > 0) {
                            players[currentIndex].pointHistory.pop(); // bớt điểm
                            currentScore--;
                            sendData(currentIndex, "update_score_pool", -1);
                          }
                        }

                        scoreEl.textContent = currentScore;
                      });
                    });
                } else {
                  players.forEach((p) => {
                    p.ball = [];
                    p.foul = 0;
                    if (configRequestTimePool !== 0) {
                      p.extraTime = timeOut;
                    }
                  });
                  foulText.textContent = "Lỗi: 0";

                  // balls = getInitialBalls(totalBalls);
                  switch (matchType) {
                    case 4:
                      balls = getInitialBalls(9);
                      break;
                    case 5:
                      balls = getInitialBalls(10);
                      break;
                    case 7:
                      balls = getInitialBalls(15);
                      break;
                    default:
                      balls = getInitialBalls(totalBalls);
                  }

                  // reset lại newBalls để render chuẩn
                  newBalls = balls.map((n) => `/images/ball${n}.png`);
                  // newBalls = ballsList.slice();
                  // console.log("newBalls", newBalls);

                  // reset container state
                  let container = document.querySelector(".balls-container");
                  if (container) {
                    container.style.pointerEvents = "auto";
                    container.style.opacity = "1";
                  }

                  renderPlayer();
                }
                break;

              case "app_return_ball":
                const playerReturnBall = players.find(
                  (x) => x.id === message.data.playerId,
                );
                if (!playerReturnBall) return;

                // Xóa ball trong player
                playerReturnBall.ball = playerReturnBall.ball.filter(
                  (b) => b !== message.data.ball,
                );

                // Thêm ball lại vào danh sách balls gốc
                balls.push(message.data.ball);
                // Nếu trả lại bi cuối cùng (9 hoặc 10) thì gỡ disable
                if (
                  (matchType === 4 && message.data.ball === 9) ||
                  (matchType === 5 && message.data.ball === 10)
                ) {
                  let container = document.querySelector(".balls-container");
                  if (container) {
                    container.style.pointerEvents = "auto";
                    container.style.opacity = "1";
                  }
                }
                renderPlayer();
                break;
              // reset countdown
              case "app_update_score_action":
                stopCountdown();
                break;
              case "app_remove_ball":
                const { ball } = message.data;
                const playerRemoveBall = players.find(
                  (x) => x.id === message.data.playerId,
                );
                if (playerRemoveBall) {
                  playerRemoveBall.ball.push(ball);
                  balls = balls.filter((b) => b !== ball);
                  playerRemoveBall.foul = 0; // reset tất cả foul về 0
                  foulText.textContent = "Lỗi: 0";
                  // disable bi khi app truyền lên là bi 9 hoặc bi 10.
                  if (
                    (matchType === 4 && ball === 9) ||
                    (matchType === 5 && ball === 10)
                  ) {
                    let container = document.querySelector(".balls-container");
                    if (container) {
                      container.style.pointerEvents = "none";
                      container.style.opacity = "0.5";
                    }
                  }
                  renderPlayer();
                }
                break;

              case "change_name":
                const { playerId, name } = message.data;

                const playerToRename = players.find((p) => p.id === playerId);
                if (playerToRename) playerToRename.name = name;

                renderPlayer();
                break;

              case "update_score":
                const { playerId: id } = message.data;
                const player = players.find((p) => p.id === id);
                if (player) player.score = message.data.score;
                renderPlayer();
                break;

              case "app_update_score":
                const { playerId: pid, score } = message.data;
                const playerToUpdate = players.find((p) => p.id === pid);
                if (playerToUpdate) {
                  playerToUpdate.score = score;
                }

                if (matchType !== 6) {
                  if (playerToUpdate.foul >= 3) {
                    players.forEach((p) => (p.foul = 0)); // reset tất cả foul về 0
                    foulText.textContent = "Lỗi: 0"; // xóa text lỗi
                  } else {
                    playerToUpdate.foul = 0;
                  }
                }
                renderPlayer();
                break;

              case "app_switch_turn":
                // Tìm thằng đang active
                const currentIdx = players.findIndex((p) => p.isActive);

                // Nếu có thằng active thì chuyển sang thằng tiếp theo
                if (currentIdx !== -1) {
                  const nextIndex = (currentIdx + 1) % players.length;

                  players = players.map((p, i) => ({
                    ...p,
                    isActive: i === nextIndex,
                  }));

                  currentIndex = nextIndex; // Cập nhật luôn currentIndex
                } else {
                  // Nếu chưa có thằng nào active, cho thằng đầu tiên
                  players = players.map((p, i) => ({
                    ...p,
                    isActive: i === 0,
                  }));
                  currentIndex = 0;
                }
                stopCountdown();
                renderPlayer();
                break;

              case "switch_turn":
                const activeId = message.data.playerId;

                players = players.map((p) => ({
                  ...p,
                  isActive: p.id === activeId, // chỉ playerId này được true
                }));

                stopCountdown();
                renderPlayer();
                break;

              case "request_extra_time":
                const playerExtraTime = players.find(
                  (p) => p.id === message.data.playerId,
                );
                if (playerExtraTime) {
                  playerExtraTime.extraTime = message.data.extraTime;
                  renderPlayer();
                  if (playerExtraTime.isActive) {
                    const countdownDuration = 10 * 1000; // 10s
                    const endTime = Date.now() + countdownDuration;

                    // lưu vào localStorage
                    localStorage.setItem("extraTimeEnd", endTime.toString());

                    startCountdown(endTime);
                  }
                }

                break;

              case "app_update_foul":
                const playerUpdateFoul = players.find(
                  (p) => p.id === message.data.playerId,
                );
                if (playerUpdateFoul) playerUpdateFoul.foul = message.data.foul;
                foulText.textContent = message.data.foul;

                if (matchType !== 6) {
                  if (playerUpdateFoul.foul >= 3) {
                    players.forEach((p) => (p.foul = 0)); // reset tất cả foul về 0
                    foulText.textContent = "Lỗi: 0"; // xóa text lỗi
                  } else {
                    foulText.textContent = "Lỗi: " + playerUpdateFoul.foul;
                  }
                }
                renderPlayer();
                break;

              case "disconnect":
                const { room, playerIds, device } = message.data;
                // Xóa room khỏi object rooms
                if (room) {
                  window.location.href = "/index.html";
                }

                break;
            }
            break;

          default:
            console.log("Unknown message:", message);
        }
      } catch (e) {
        console.error("Error parsing message:", e);
      }
    };

    ws.onclose = (event) => {
      console.log("WebSocket disconnected:", event.code, event.reason);
      stopHeartbeat();
    };

    ws.onerror = (e) => {
      console.error("Lỗi WebSocket:", e);
    };
  }

  // --- Nút phạm lỗi ---
  btnFoul.addEventListener("click", () => {
    if ((!isRunning && timeMode === 1) || players.length === 0) return;
    if (gameStart && gameRunning) {
      executeAction(() => {
        sendData(currentIndex, "update_foul");
      });
    }
  });

  //  --- Nút trận mới ---
  btnNewRound.addEventListener("click", () => {
    if (!isRunning && timeMode === 1) return;
    if (gameStart && gameRunning) {
      if (ws && ws.readyState === WebSocket.OPEN) {
        if (matchType === 6) {
          const payload = {
            type: "command",
            action: "new_round_pool",
          };
          ws.send(JSON.stringify(payload));
          if (configRequestTimePool !== 0) {
            players.forEach((p) => {
              p.pointHistory = [];
              p.extraTime = timeOut;
            });
          } else {
            players.forEach((p) => {
              p.pointHistory = [];
            });
          }

          renderPlayer();
        } else {
          const payload = {
            type: "command",
            action: "new_round",
          };

          ws.send(JSON.stringify(payload));

          if (configRequestTimePool !== 0) {
            players.forEach((p) => {
              p.ball = [];
              p.foul = 0;
              p.extraTime = timeOut;
            });
          } else {
            players.forEach((p) => {
              p.ball = [];
              p.foul = 0;
            });
          }

          foulText.textContent = "Lỗi: 0"; // xóa text lỗi

          // balls = getInitialBalls(totalBalls);
          switch (matchType) {
            case 4:
              balls = getInitialBalls(9);
              break;
            case 5:
              balls = getInitialBalls(10);
              break;
            case 7:
              balls = getInitialBalls(15);
              break;
            default:
              balls = getInitialBalls(totalBalls);
          }
          // reset lại newBalls để render chuẩn
          newBalls = ballsList.slice();
          let container = document.querySelector(".balls-container");
          if (!container) {
            container = document.createElement("div");
            container.className = "balls-container";
            document.body.appendChild(container);
          }
          container.style.pointerEvents = "auto";
          container.style.opacity = "1";
          renderPlayer();
        }
      }
    }
  });

  // --- Nút ngắt kết nối ---
  btnDisconnect.addEventListener("click", () => {
    if (ws && ws.readyState === WebSocket.OPEN) {
      ws.send(JSON.stringify({ type: "disconnect", room: roomId }));
    }
    // localStorage.clear();
    sessionStorage.clear();
    window.location.href = "/index.html";
  });

  // --- Nút đổi lượt ---
  btnTakeTurn.addEventListener("click", () => {
    if (players.length === 0 || (!isRunning && timeMode === 1)) return;
    if (gameStart && gameRunning) {
      executeAction(() => {
        players[currentIndex].isActive = false;
        currentIndex = (currentIndex + 1) % players.length;
        players[currentIndex].isActive = true;
        localStorage.setItem("CURRENT_NAME_PLAYER", players[currentIndex].name);
        renderPlayer();
        sendData(currentIndex, "switch_turn");
        stopCountdown();
        btnAskForTime.textContent = "XIN THỜI GIAN";
        canAskForTime = true;
        if (countdownInterval) {
          clearInterval(countdownInterval);
          countdownInterval = null;
        }
      });
    }
  });

  // --- Nút xin thời gian ---
  let canAskForTime = true;
  let countdownInterval = null;

  btnAskForTime.addEventListener("click", () => {
    if ((!isRunning && timeMode === 1) || !canAskForTime) return;
    if (gameStart && gameRunning) {
      const currentPlayer = players[currentIndex];
      if (!currentPlayer?.isActive) return;
      const canRequestTime =
        currentPlayer.extraTime === -1 || currentPlayer.extraTime > 0;

      if (!canRequestTime) {
        return;
      }

      // Chỉ giảm extraTime khi KHÔNG phải là -1 (không giới hạn)
      if (currentPlayer.extraTime !== -1) {
        currentPlayer.extraTime -= 1;
      }

      renderPlayer();
      sendData(currentIndex, "request_extra_time");

      // Bắt đầu cooldown 10s
      canAskForTime = false;
      let countdown = 10;
      const originalText = btnAskForTime.textContent;

      // Hiển thị ngay 10s
      btnAskForTime.textContent = `${countdown}s`;

      countdownInterval = setInterval(() => {
        countdown--;
        btnAskForTime.textContent = `${countdown}s`;

        if (countdown <= 0) {
          clearInterval(countdownInterval);
          btnAskForTime.textContent = originalText;
          canAskForTime = true;
        }
      }, 1000);
    }
  });

  // --- Nút tăng điểm ---
  btnIncrease.addEventListener("click", () => {
    const currentPlayer = players[currentIndex];
    if ((!isRunning && timeMode === 1) || !currentPlayer?.isActive) return;
    if (gameStart && gameRunning) {
      executeAction(() => {
        currentPlayer.score += 1;
        if (matchType !== 6) {
          currentPlayer.foul = 0;
        }
        renderPlayer();
        sendData(currentIndex, "update_score");
      });
    }
  });

  // --- Trừ điểm ---
  btnDisIncrease.addEventListener("click", () => {
    const currentPlayer = players[currentIndex];
    if ((!isRunning && timeMode === 1) || !currentPlayer?.isActive) return;
    if (gameStart && gameRunning) {
      executeAction(() => {
        currentPlayer.score -= 1;
        if (matchType !== 6) {
          currentPlayer.foul = 0;
        }
        renderPlayer();
        sendData(currentIndex, "update_score");
      });
    }
  });

  // --- Nút tạm dừng ---
  btnPause.addEventListener("click", () => {
    if (!gameStart || !gameRunning) return;
    if (timeMode !== 1) return; // Chỉ hoạt động khi timeMode = 1

    isRunning = !isRunning;
    updatePauseButton();
    sendData(currentIndex, "toggle_pause");
  });

  // --- Nút đổi bi ---
  btnChangeBall.addEventListener("click", () => {
    if (!isRunning && timeMode === 1) return;
    if (!gameStart || !gameRunning) return;

    executeAction(() => {
      const activePlayer = players[currentIndex];
      if (!activePlayer) return;

      if (players.length === 2) {
        const newIsFirstBallHitter =
          activePlayer.isFirstBallHitter === 1 ? 0 : 1;

        players = players.map((player, index) => {
          if (index === currentIndex) {
            return {
              ...player,
              isFirstBallHitter: newIsFirstBallHitter,
            };
          } else {
            return {
              ...player,
              isFirstBallHitter: newIsFirstBallHitter === 1 ? 0 : 1,
            };
          }
        });

        renderPlayer();
        sendData(currentIndex, "change_ball_pool");
      }
    });
  });

  // ==== hàm đếm thời gian 10s khi load lai trang vẫn tiếp tục đếm ===
  function startCountdown(endTime) {
    if (countdownInterval) clearInterval(countdownInterval);
    btnAskForTime.disabled = true;

    countdownInterval = setInterval(() => {
      const remaining = Math.max(0, Math.ceil((endTime - Date.now()) / 1000));
      btnAskForTime.textContent = `${remaining}s`;

      if (remaining <= 0) {
        clearInterval(countdownInterval);
        localStorage.removeItem("extraTimeEnd");
        btnAskForTime.disabled = false;
        btnAskForTime.textContent = "XIN THỜI GIAN";
      }
    }, 200);
  }

  function stopCountdown() {
    // Dừng interval
    if (countdownInterval) {
      clearInterval(countdownInterval);
      countdownInterval = null;
    }

    // Reset UI
    btnAskForTime.disabled = false;
    btnAskForTime.textContent = "XIN THỜI GIAN";

    // Xóa dữ liệu localStorage
    localStorage.removeItem("extraTimeEnd");

    // Reset biến trạng thái (nếu có)
    canAskForTime = true;
  }

  window.addEventListener("load", () => {
    const savedEnd = localStorage.getItem("extraTimeEnd");
    if (savedEnd) {
      const endTime = Number(savedEnd);
      if (Date.now() < endTime) {
        startCountdown(endTime); // tiếp tục countdown
      } else {
        localStorage.removeItem("extraTimeEnd");
      }
    }
  });

  // Khởi chạy
  updatePauseButton();
  updateChangeBallButtonVisibility();
  renderPlayer();
  connectWebSocket();
})();
